﻿using System;
using System.Configuration; 
using System.Collections.Generic;
using System.Web;
using System.Web.Configuration; 
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class CrsSettingsManager
    {
        public CrsSettingsManager() { }

        public List<CRS_SETTINGS> GetTbiCubeSettings()
        {
            List<CRS_SETTINGS> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataReader sReader = null;

            try
            {
                sConn = new SqlConnection(GlobalSettings.DALConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("TBI.GET_CUBE_SETTINGS", sConn);
                sCmd.CommandTimeout = GetConfigEntryOrDefault("CommandTimeout", 60);
                sCmd.CommandType = CommandType.StoredProcedure;
                sReader = sCmd.ExecuteReader();

                while (sReader.Read())
                {
                    CRS_SETTINGS setting = ParseReaderNameValue(sReader);
                    if (objReturn == null) { objReturn = new List<CRS_SETTINGS>(); }
                    objReturn.Add(setting);
                }

                sReader.Close();
                sConn.Close();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                if (sReader != null)
                {
                    if (!sReader.IsClosed) { sReader.Close(); }
                    sReader.Dispose();
                    sReader = null;
                }
                if (sCmd != null) { sCmd.Dispose(); sCmd = null; }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public CRS_SETTINGS ParseReader(SqlDataReader sReader)
        {
            CRS_SETTINGS objReturn = new CRS_SETTINGS();

            objReturn.CRS_SETTINGS_ID = (int)GetNullableObject(sReader["CRS_SETTINGS_ID"]);
            objReturn.STD_REGISTRY_ID = (int)GetNullableObject(sReader["STD_REGISTRY_ID"]);
            objReturn.NAME = (string)GetNullableObject(sReader["NAME"]);
            objReturn.VALUE = (string)GetNullableObject(sReader["VALUE"]);
            objReturn.DESCRIPTION = (string)GetNullableObject(sReader["DESCRIPTION"]);
            objReturn.COMMENTS = (string)GetNullableObject(sReader["COMMENTS"]);
            objReturn.CREATED = (DateTime)GetNullableObject(sReader["CREATED"]);
            objReturn.CREATEDBY = (string)GetNullableObject(sReader["CREATEDBY"]);

            return objReturn;
        }
        public string GetTbiSettings(string strCMD, string sKey)
        {
            //List<CRS_SETTINGS> objReturn = null;
            string sSetting = "";
            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataReader sReader = null;

            try
            {
                sConn = new SqlConnection(GlobalSettings.DALConnectionString);

                sConn.Open();

                sCmd = new SqlCommand(strCMD, sConn);
                SqlParameter param = new SqlParameter();
                param.ParameterName = "@KeyName";
                param.Value = sKey;
                sCmd.Parameters.Add(param);
                sCmd.CommandTimeout = GetConfigEntryOrDefault("CommandTimeout", 60);
                sCmd.CommandType = CommandType.StoredProcedure;
                sReader = sCmd.ExecuteReader();

                while (sReader.Read())
                {
                    //CRS_SETTINGS setting = ParseReaderNameValue1(sReader);
                    //if (objReturn == null) { objReturn = new List<CRS_SETTINGS>(); }
                    //objReturn.Add(setting);
                    sSetting = sReader["VALUE"].ToString();
                }

                sReader.Close();
                sConn.Close();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                if (sReader != null)
                {
                    if (!sReader.IsClosed) { sReader.Close(); }
                    sReader.Dispose();
                    sReader = null;
                }
                if (sCmd != null) { sCmd.Dispose(); sCmd = null; }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return sSetting;
        }
        public CRS_SETTINGS ParseReaderNameValue(SqlDataReader sReader)
        {
            CRS_SETTINGS objReturn = new CRS_SETTINGS();

            objReturn.NAME = (string)GetNullableObject(sReader["NAME"]);
            objReturn.VALUE = (string)GetNullableObject(sReader["VALUE"]);

            return objReturn;
        }
        public string ParseReaderNameValue1(SqlDataReader sReader)
        {
            //CRS_SETTINGS objReturn = new CRS_SETTINGS();
            string objReturn = "";
            objReturn = (string)GetNullableObject(sReader["VALUE"]);

            return objReturn;
        }
        private object GetNullableObject(object dbval)
        {
            if (dbval != DBNull.Value)
            {
                return dbval;
            }
            else
            {
                if (dbval is DateTime)
                    return DateTime.MinValue;
                else if (dbval is int)
                    return -1;
                else
                    return string.Empty;
            }
        }

        private int GetConfigEntryOrDefault(string key, int defaultVal)
        {
            string value = WebConfigurationManager.AppSettings.Get(key);

            if (string.IsNullOrEmpty(value))
                return defaultVal;

            int result;
            if (int.TryParse(value, out result))
                return result;

            else
                throw new ConfigurationException("Specified key is invalid");



        }
    }
}
